/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;

class SleuthHttpServerParser
extends HttpServerParser {
    private static final String STATUS_CODE_KEY = "http.status_code";
    private final SleuthHttpClientParser clientParser;
    private final ErrorParser errorParser;

    SleuthHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        this.clientParser = new SleuthHttpClientParser(traceKeys);
        this.errorParser = errorParser;
    }

    @Override
    protected ErrorParser errorParser() {
        return this.errorParser;
    }

    @Override
    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return this.clientParser.spanName(adapter, req);
    }

    @Override
    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer2) {
        this.clientParser.request(adapter, req, customizer2);
    }

    @Override
    public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer2) {
        if (res == null) {
            this.error(null, error, customizer2);
            return;
        }
        Integer httpStatus = adapter.statusCode(res);
        if (httpStatus == null) {
            this.error(httpStatus, error, customizer2);
            return;
        }
        if (httpStatus == 200 && error != null) {
            customizer2.tag(STATUS_CODE_KEY, String.valueOf(500));
        } else if (httpStatus >= 100 && httpStatus < 200 || httpStatus > 399) {
            customizer2.tag(STATUS_CODE_KEY, String.valueOf(httpStatus));
        }
        this.error(httpStatus, error, customizer2);
    }
}

