/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import java.util.regex.Pattern;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;

class SleuthHttpSampler
extends HttpSampler {
    private final Pattern pattern;

    SleuthHttpSampler(SkipPatternProvider provider) {
        this.pattern = provider.skipPattern();
    }

    @Override
    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        String url = adapter.path(request);
        boolean shouldSkip = this.pattern.matcher(url).matches();
        if (shouldSkip) {
            return false;
        }
        return null;
    }
}

