/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import java.net.URI;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

class SleuthHttpClientParser
extends HttpClientParser {
    private static final String HOST_KEY = "http.host";
    private static final String METHOD_KEY = "http.method";
    private static final String PATH_KEY = "http.path";
    private static final String URL_KEY = "http.url";
    private final TraceKeys traceKeys;

    SleuthHttpClientParser(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    @Override
    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return this.getName(URI.create(adapter.url(req)));
    }

    @Override
    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer2) {
        super.request(adapter, req, customizer2);
        String url = adapter.url(req);
        URI uri = URI.create(url);
        this.addRequestTags(customizer2, url, uri.getHost(), uri.getPath(), adapter.method(req));
        this.traceKeys.getHttp().getHeaders().forEach(s -> {
            String headerValue = adapter.requestHeader(req, (String)s);
            if (headerValue != null) {
                customizer2.tag(this.key((String)s), headerValue);
            }
        });
    }

    private String key(String key) {
        return this.traceKeys.getHttp().getPrefix() + key.toLowerCase();
    }

    private String getName(URI uri) {
        return SpanNameUtil.shorten(this.uriScheme(uri) + ":" + uri.getRawPath());
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    private void addRequestTags(SpanCustomizer customizer2, String url, String host, String path, String method) {
        customizer2.tag(URL_KEY, url);
        if (host != null) {
            customizer2.tag(HOST_KEY, host);
        }
        customizer2.tag(PATH_KEY, path);
        customizer2.tag(METHOD_KEY, method);
    }
}

