/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ExceptionLoggingFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ExceptionLoggingFilter.class);

    ExceptionLoggingFilter() {
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Uncaught exception thrown", e);
            }
            throw e;
        }
    }

    @Override
    public void destroy() {
    }
}

