/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Tracing;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.sleuth.instrument.reactor.ApplicationContextRefreshedListener;
import org.springframework.cloud.sleuth.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.instrument.reactor.LastOperatorWrapper;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFluxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.reactor.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Mono.class})
@AutoConfigureAfter(value={TraceWebFluxAutoConfiguration.class})
public class TraceReactorAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={Tracing.class})
    static class TraceReactorConfiguration {
        static final String SLEUTH_TRACE_REACTOR_KEY = TraceReactorConfiguration.class.getName();

        TraceReactorConfiguration() {
        }

        @Bean
        @ConditionalOnNotWebApplication
        LastOperatorWrapper spanOperator() {
            return beanFactory -> Hooks.onLastOperator((String)SLEUTH_TRACE_REACTOR_KEY, ReactorSleuth.spanOperator(beanFactory));
        }

        @Bean
        @ConditionalOnWebApplication
        LastOperatorWrapper noOpLastOperatorWrapper() {
            return beanFactory -> {};
        }

        @PreDestroy
        public void cleanupHooks() {
            Hooks.resetOnLastOperator((String)SLEUTH_TRACE_REACTOR_KEY);
            Hooks.resetOnEachOperator((String)SLEUTH_TRACE_REACTOR_KEY);
            Schedulers.resetFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        static HookRegisteringBeanDefinitionRegistryPostProcessor traceHookRegisteringBeanDefinitionRegistryPostProcessor() {
            return new HookRegisteringBeanDefinitionRegistryPostProcessor();
        }

        @Bean
        ApplicationContextRefreshedListener traceApplicationContextRefreshedListener() {
            return new ApplicationContextRefreshedListener();
        }
    }
}

