/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.context.Context;

final class ScopePassingSpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private static final Log log = LogFactory.getLog(ScopePassingSpanSubscriber.class);
    private final TraceContext spanTraceContext;
    private final CurrentTraceContext currentTraceContext;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private Subscription s;

    ScopePassingSpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracing tracing) {
        this.subscriber = subscriber;
        this.currentTraceContext = tracing.currentTraceContext();
        Span root = ctx != null ? (Span)ctx.getOrDefault(Span.class, (Object)tracing.tracer().currentSpan()) : null;
        TraceContext traceContext = this.spanTraceContext = root != null ? root.context() : null;
        Context context = ctx != null && root != null ? ctx.put(Span.class, (Object)root) : (this.context = ctx != null ? ctx : Context.empty());
        if (log.isTraceEnabled()) {
            log.trace("Root span [" + root + "], context [" + this.context + "]");
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.s = subscription;
        try (CurrentTraceContext.Scope inScope = this.currentTraceContext.maybeScope(this.spanTraceContext);){
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        try (CurrentTraceContext.Scope inScope = this.currentTraceContext.maybeScope(this.spanTraceContext);){
            this.s.request(n);
        }
    }

    public void cancel() {
        try (CurrentTraceContext.Scope inScope = this.currentTraceContext.maybeScope(this.spanTraceContext);){
            this.s.cancel();
        }
    }

    public void onNext(T o) {
        try (CurrentTraceContext.Scope inScope = this.currentTraceContext.maybeScope(this.spanTraceContext);){
            this.subscriber.onNext(o);
        }
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public Context currentContext() {
        return this.context;
    }
}

