/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.ScopedSpan;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import java.util.concurrent.Callable;
import org.springframework.cloud.sleuth.SpanNamer;

public class TraceCallable<V>
implements Callable<V> {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final Tracer tracer;
    private final Callable<V> delegate;
    private final TraceContext parent;
    private final String spanName;

    public TraceCallable(Tracing tracing, SpanNamer spanNamer, Callable<V> delegate) {
        this(tracing, spanNamer, delegate, null);
    }

    public TraceCallable(Tracing tracing, SpanNamer spanNamer, Callable<V> delegate, String name) {
        this.tracer = tracing.tracer();
        this.delegate = delegate;
        this.parent = tracing.currentTraceContext().get();
        this.spanName = name != null ? name : spanNamer.name(delegate, DEFAULT_SPAN_NAME);
    }

    @Override
    public V call() throws Exception {
        ScopedSpan span = this.tracer.startScopedSpanWithParent(this.spanName, this.parent);
        try {
            V v = this.delegate.call();
            return v;
        }
        catch (Error | Exception e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

