/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.List;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.configuration.CompatibilityNotMetException;
import org.springframework.cloud.configuration.VerificationResult;

public final class CompatibilityNotMetFailureAnalyzer
extends AbstractFailureAnalyzer<CompatibilityNotMetException> {
    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, CompatibilityNotMetException cause) {
        return new FailureAnalysis(this.getDescription(cause), this.getAction(cause), cause);
    }

    private String getDescription(CompatibilityNotMetException ex) {
        return String.format("Your project setup is incompatible with our requirements due to following reasons:%s", this.descriptions(ex.results));
    }

    private String descriptions(List<VerificationResult> results) {
        StringBuilder builder = new StringBuilder("\n\n");
        for (VerificationResult result : results) {
            builder.append("- ").append(result.description).append("\n");
        }
        return builder.toString();
    }

    private String getAction(CompatibilityNotMetException ex) {
        return String.format("Consider applying the following actions:%s", this.actions(ex.results));
    }

    private String actions(List<VerificationResult> results) {
        StringBuilder builder = new StringBuilder("\n\n");
        for (VerificationResult result : results) {
            builder.append("- ").append(result.action).append("\n");
        }
        return builder.toString();
    }
}

