/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;

public class DiscoveryCompositeHealthIndicator
extends CompositeHealthIndicator {
    private final ArrayList<Holder> healthIndicators = new ArrayList();

    @Autowired
    public DiscoveryCompositeHealthIndicator(HealthAggregator healthAggregator, List<DiscoveryHealthIndicator> indicators) {
        super(healthAggregator);
        for (DiscoveryHealthIndicator indicator : indicators) {
            Holder holder = new Holder(indicator);
            this.addHealthIndicator(indicator.getName(), holder);
            this.healthIndicators.add(holder);
        }
    }

    public ArrayList<Holder> getHealthIndicators() {
        return this.healthIndicators;
    }

    public static class Holder
    implements HealthIndicator {
        private DiscoveryHealthIndicator delegate;

        public Holder(DiscoveryHealthIndicator delegate) {
            this.delegate = delegate;
        }

        @Override
        public Health health() {
            return this.delegate.health();
        }

        public DiscoveryHealthIndicator getDelegate() {
            return this.delegate;
        }
    }
}

