/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.web.context.WebApplicationContext;

public class ManagementServerPortUtils {
    static final boolean hasActuator;

    private static boolean hasClass(String className) {
        boolean hasClass;
        try {
            Class.forName(className);
            hasClass = true;
        }
        catch (ClassNotFoundException e) {
            hasClass = false;
        }
        return hasClass;
    }

    public static ManagementServerPort get(BeanFactory beanFactory) {
        return ManagementServerPort.get(beanFactory);
    }

    public static boolean isDifferent(BeanFactory beanFactory) {
        return ManagementServerPortUtils.get(beanFactory) == ManagementServerPort.DIFFERENT;
    }

    public static boolean isDisabled(BeanFactory beanFactory) {
        return ManagementServerPortUtils.get(beanFactory) == ManagementServerPort.DISABLE;
    }

    public static boolean isSame(BeanFactory beanFactory) {
        return ManagementServerPortUtils.get(beanFactory) == ManagementServerPort.SAME;
    }

    public static Integer getPort(BeanFactory beanFactory) {
        if (!hasActuator) {
            return null;
        }
        try {
            ManagementServerProperties properties = beanFactory.getBean(ManagementServerProperties.class);
            return properties.getPort();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    static {
        boolean hasEndpointClass = ManagementServerPortUtils.hasClass("org.springframework.boot.actuate.endpoint.annotation.Endpoint");
        boolean hasManagementServerPropertiesClass = ManagementServerPortUtils.hasClass("org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties");
        hasActuator = hasEndpointClass && hasManagementServerPropertiesClass;
    }

    public static enum ManagementServerPort {
        DISABLE,
        SAME,
        DIFFERENT;


        public static ManagementServerPort get(BeanFactory beanFactory) {
            ManagementServerProperties managementServerProperties;
            ServerProperties serverProperties;
            if (!hasActuator) {
                return SAME;
            }
            try {
                serverProperties = beanFactory.getBean(ServerProperties.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                serverProperties = new ServerProperties();
            }
            try {
                managementServerProperties = beanFactory.getBean(ManagementServerProperties.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                managementServerProperties = new ManagementServerProperties();
            }
            Integer port = managementServerProperties.getPort();
            if (port != null && port < 0) {
                return DISABLE;
            }
            if (!(beanFactory instanceof WebApplicationContext)) {
                return DIFFERENT;
            }
            return port == null || serverProperties.getPort() == null && port.equals(8080) || port != 0 && port.equals(serverProperties.getPort()) ? SAME : DIFFERENT;
        }
    }
}

