/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={TextEncryptor.class})
@EnableConfigurationProperties(value={KeyProperties.class})
public class EncryptionBootstrapConfiguration {
    @Autowired(required=false)
    private TextEncryptor encryptor;
    @Autowired
    private KeyProperties key;

    @Bean
    public EnvironmentDecryptApplicationInitializer environmentDecryptApplicationListener() {
        if (this.encryptor == null) {
            this.encryptor = new FailsafeTextEncryptor();
        }
        EnvironmentDecryptApplicationInitializer listener = new EnvironmentDecryptApplicationInitializer(this.encryptor);
        listener.setFailOnError(this.key.isFailOnError());
        return listener;
    }

    protected static class FailsafeTextEncryptor
    implements TextEncryptor {
        protected FailsafeTextEncryptor() {
        }

        @Override
        public String encrypt(String text) {
            throw new UnsupportedOperationException("No encryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }

        @Override
        public String decrypt(String encryptedText) {
            throw new UnsupportedOperationException("No decryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }
    }

    public static class KeyCondition
    extends SpringBootCondition {
        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment2 = context.getEnvironment();
            if (this.hasProperty(environment2, "encrypt.key-store.location")) {
                if (this.hasProperty(environment2, "encrypt.key-store.password")) {
                    return ConditionOutcome.match("Keystore found in Environment");
                }
                return ConditionOutcome.noMatch("Keystore found but no password in Environment");
            }
            if (this.hasProperty(environment2, "encrypt.key")) {
                return ConditionOutcome.match("Key found in Environment");
            }
            return ConditionOutcome.noMatch("Keystore nor key found in Environment");
        }

        private boolean hasProperty(Environment environment2, String key) {
            String value = environment2.getProperty(key);
            if (value == null) {
                return false;
            }
            return StringUtils.hasText(environment2.resolvePlaceholders(value));
        }
    }

    @Configuration
    @Conditional(value={KeyCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.security.rsa.crypto.RsaSecretEncryptor"})
    protected static class VanillaEncryptionConfiguration {
        @Autowired
        private KeyProperties key;

        protected VanillaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor() {
            return new EncryptorFactory(this.key.getSalt()).create(this.key.getKey());
        }
    }

    @Configuration
    @Conditional(value={KeyCondition.class})
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    @EnableConfigurationProperties(value={RsaProperties.class})
    protected static class RsaEncryptionConfiguration {
        @Autowired
        private KeyProperties key;
        @Autowired
        private RsaProperties rsaProperties;

        protected RsaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor() {
            KeyProperties.KeyStore keyStore = this.key.getKeyStore();
            if (keyStore.getLocation() != null) {
                if (keyStore.getLocation().exists()) {
                    return new RsaSecretEncryptor(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()).getKeyPair(keyStore.getAlias(), keyStore.getSecret().toCharArray()), this.rsaProperties.getAlgorithm(), this.rsaProperties.getSalt(), this.rsaProperties.isStrong());
                }
                throw new IllegalStateException("Invalid keystore location");
            }
            return new EncryptorFactory(this.key.getSalt()).create(this.key.getKey());
        }
    }
}

