/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.ManagerBase;
import org.springframework.boot.web.embedded.tomcat.LazySessionIdGenerator;
import org.springframework.boot.web.embedded.tomcat.TomcatStarter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TomcatEmbeddedContext
extends StandardContext {
    private TomcatStarter starter;
    private final boolean overrideLoadOnStart = ReflectionUtils.findMethod(StandardContext.class, "loadOnStartup", Container[].class).getReturnType() == Boolean.TYPE;

    TomcatEmbeddedContext() {
    }

    @Override
    public boolean loadOnStartup(Container[] children) {
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup(children);
    }

    @Override
    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            ((ManagerBase)manager).setSessionIdGenerator(new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    public void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            existingLoader = ClassUtils.overrideThreadContextClassLoader(classLoader);
        }
        if (this.overrideLoadOnStart) {
            super.loadOnStartup(this.findChildren());
        }
        if (existingLoader != null) {
            ClassUtils.overrideThreadContextClassLoader(existingLoader);
        }
    }

    public void setStarter(TomcatStarter starter) {
        this.starter = starter;
    }

    public TomcatStarter getStarter() {
        return this.starter;
    }
}

