/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;

class CompressionConnectorCustomizer
implements TomcatConnectorCustomizer {
    private final Compression compression;

    CompressionConnectorCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler;
        if (this.compression != null && this.compression.getEnabled() && (handler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
            this.customize((AbstractHttp11Protocol)handler);
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(compression.getMinResponseSize());
        protocol.setCompressibleMimeType(StringUtils.arrayToCommaDelimitedString(compression.getMimeTypes()));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(StringUtils.arrayToCommaDelimitedString(this.compression.getExcludedUserAgents()));
        }
    }
}

