/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    @Override
    public final int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.initMocks(testContext);
        this.injectFields(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.initMocks(testContext);
            this.reinjectFields(testContext);
        }
    }

    private void initMocks(TestContext testContext) {
        if (this.hasMockitoAnnotations(testContext)) {
            MockitoAnnotations.initMocks(testContext.getTestInstance());
        }
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollection collector = new MockitoAnnotationCollection();
        ReflectionUtils.doWithFields(testContext.getTestClass(), collector);
        return collector.hasAnnotations();
    }

    private void injectFields(TestContext testContext) {
        this.postProcessFields(testContext, (mockitoField, postProcessor) -> postProcessor.inject(((MockitoField)mockitoField).field, ((MockitoField)mockitoField).target, ((MockitoField)mockitoField).definition));
    }

    private void reinjectFields(TestContext testContext) {
        this.postProcessFields(testContext, (mockitoField, postProcessor) -> {
            ReflectionUtils.makeAccessible(((MockitoField)mockitoField).field);
            ReflectionUtils.setField(((MockitoField)mockitoField).field, testContext.getTestInstance(), null);
            postProcessor.inject(((MockitoField)mockitoField).field, ((MockitoField)mockitoField).target, ((MockitoField)mockitoField).definition);
        });
    }

    private void postProcessFields(TestContext testContext, BiConsumer<MockitoField, MockitoPostProcessor> consumer) {
        DefinitionsParser parser = new DefinitionsParser();
        parser.parse(testContext.getTestClass());
        if (!parser.getDefinitions().isEmpty()) {
            MockitoPostProcessor postProcessor = testContext.getApplicationContext().getBean(MockitoPostProcessor.class);
            for (Definition definition : parser.getDefinitions()) {
                Field field = parser.getField(definition);
                if (field == null) continue;
                consumer.accept(new MockitoField(field, testContext.getTestInstance(), definition), postProcessor);
            }
        }
    }

    private static final class MockitoField {
        private final Field field;
        private final Object target;
        private final Definition definition;

        private MockitoField(Field field, Object instance, Definition definition) {
            this.field = field;
            this.target = instance;
            this.definition = definition;
        }
    }

    private static class MockitoAnnotationCollection
    implements ReflectionUtils.FieldCallback {
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollection() {
        }

        @Override
        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith("org.mockito")) continue;
                this.annotations.add(annotation);
            }
        }

        public boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }
}

