/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.assertj.AssertableWebApplicationContext;
import org.springframework.boot.test.context.runner.AbstractApplicationContextRunner;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public final class WebApplicationContextRunner
extends AbstractApplicationContextRunner<WebApplicationContextRunner, ConfigurableWebApplicationContext, AssertableWebApplicationContext> {
    public WebApplicationContextRunner() {
        this(WebApplicationContextRunner.withMockServletContext(AnnotationConfigWebApplicationContext::new));
    }

    public WebApplicationContextRunner(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        super(contextFactory);
    }

    private WebApplicationContextRunner(Supplier<ConfigurableWebApplicationContext> contextFactory, List<ApplicationContextInitializer<ConfigurableWebApplicationContext>> initializers, TestPropertyValues environmentProperties, TestPropertyValues systemProperties, ClassLoader classLoader, ApplicationContext parent, List<Configurations> configurations) {
        super(contextFactory, initializers, environmentProperties, systemProperties, classLoader, parent, configurations);
    }

    @Override
    protected WebApplicationContextRunner newInstance(Supplier<ConfigurableWebApplicationContext> contextFactory, List<ApplicationContextInitializer<ConfigurableWebApplicationContext>> initializers, TestPropertyValues environmentProperties, TestPropertyValues systemProperties, ClassLoader classLoader, ApplicationContext parent, List<Configurations> configurations) {
        return new WebApplicationContextRunner(contextFactory, initializers, environmentProperties, systemProperties, classLoader, parent, configurations);
    }

    public static Supplier<ConfigurableWebApplicationContext> withMockServletContext(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        return contextFactory != null ? () -> {
            ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)contextFactory.get();
            context.setServletContext(new MockServletContext());
            return context;
        } : null;
    }
}

