/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.convert.DurationFormat;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

final class DurationToStringConverter
implements GenericConverter {
    DurationToStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Duration.class, String.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        DurationFormat format = sourceType.getAnnotation(DurationFormat.class);
        DurationUnit unit = sourceType.getAnnotation(DurationUnit.class);
        return this.convert((Duration)source, format != null ? format.value() : null, unit != null ? unit.value() : null);
    }

    private String convert(Duration source, DurationStyle style, ChronoUnit unit) {
        style = style != null ? style : DurationStyle.ISO8601;
        return style.print(source, unit);
    }
}

