/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.annotation.Validated;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
PriorityOrdered,
ApplicationContextAware,
InitializingBean {
    public static final String BEAN_NAME = ConfigurationPropertiesBindingPostProcessor.class.getName();
    public static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    private ConfigurationBeanFactoryMetadata beanFactoryMetadata;
    private ApplicationContext applicationContext;
    private ConfigurationPropertiesBinder configurationPropertiesBinder;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.beanFactoryMetadata = this.applicationContext.getBean(ConfigurationBeanFactoryMetadata.BEAN_NAME, ConfigurationBeanFactoryMetadata.class);
        this.configurationPropertiesBinder = new ConfigurationPropertiesBinder(this.applicationContext, VALIDATOR_BEAN_NAME);
    }

    @Override
    public int getOrder() {
        return -2147483647;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        ConfigurationProperties annotation = this.getAnnotation(bean2, beanName, ConfigurationProperties.class);
        if (annotation != null) {
            this.bind(bean2, beanName, annotation);
        }
        return bean2;
    }

    private void bind(Object bean2, String beanName, ConfigurationProperties annotation) {
        Annotation[] annotationArray;
        ResolvableType type = this.getBeanType(bean2, beanName);
        Validated validated = this.getAnnotation(bean2, beanName, Validated.class);
        if (validated != null) {
            Annotation[] annotationArray2 = new Annotation[2];
            annotationArray2[0] = annotation;
            annotationArray = annotationArray2;
            annotationArray2[1] = validated;
        } else {
            Annotation[] annotationArray3 = new Annotation[1];
            annotationArray = annotationArray3;
            annotationArray3[0] = annotation;
        }
        Annotation[] annotations = annotationArray;
        Bindable<Object> target = Bindable.of(type).withExistingValue(bean2).withAnnotations(annotations);
        try {
            this.configurationPropertiesBinder.bind(target);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindException(beanName, bean2, annotation, ex);
        }
    }

    private ResolvableType getBeanType(Object bean2, String beanName) {
        Method factoryMethod = this.beanFactoryMetadata.findFactoryMethod(beanName);
        if (factoryMethod != null) {
            return ResolvableType.forMethodReturnType(factoryMethod);
        }
        return ResolvableType.forClass(bean2.getClass());
    }

    private <A extends Annotation> A getAnnotation(Object bean2, String beanName, Class<A> type) {
        A annotation = this.beanFactoryMetadata.findFactoryAnnotation(beanName, type);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(bean2.getClass(), type);
        }
        return annotation;
    }
}

