/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class ReactiveMongoClientFactory {
    private final MongoProperties properties;
    private final Environment environment;
    private final List<MongoClientSettingsBuilderCustomizer> builderCustomizers;

    public ReactiveMongoClientFactory(MongoProperties properties, Environment environment2, List<MongoClientSettingsBuilderCustomizer> builderCustomizers) {
        this.properties = properties;
        this.environment = environment2;
        this.builderCustomizers = builderCustomizers != null ? builderCustomizers : Collections.emptyList();
    }

    public MongoClient createMongoClient(MongoClientSettings settings) {
        Integer embeddedPort = this.getEmbeddedPort();
        if (embeddedPort != null) {
            return this.createEmbeddedMongoClient(settings, embeddedPort);
        }
        return this.createNetworkMongoClient(settings);
    }

    private Integer getEmbeddedPort() {
        String localPort;
        if (this.environment != null && (localPort = this.environment.getProperty("local.mongo.port")) != null) {
            return Integer.valueOf(localPort);
        }
        return null;
    }

    private MongoClient createEmbeddedMongoClient(MongoClientSettings settings, int port) {
        MongoClientSettings.Builder builder = this.builder(settings);
        String host = this.properties.getHost() != null ? this.properties.getHost() : "localhost";
        ClusterSettings clusterSettings = ClusterSettings.builder().hosts(Collections.singletonList(new ServerAddress(host, port))).build();
        builder.clusterSettings(clusterSettings);
        return this.createMongoClient(builder);
    }

    private MongoClient createNetworkMongoClient(MongoClientSettings settings) {
        if (this.hasCustomAddress() || this.hasCustomCredentials()) {
            return this.createCredentialNetworkMongoClient(settings);
        }
        ConnectionString connectionString = new ConnectionString(this.properties.determineUri());
        return this.createMongoClient(this.createBuilder(settings, connectionString));
    }

    private MongoClient createCredentialNetworkMongoClient(MongoClientSettings settings) {
        Assert.state(this.properties.getUri() == null, "Invalid mongo configuration, either uri or host/port/credentials must be specified");
        MongoClientSettings.Builder builder = this.builder(settings);
        if (this.hasCustomCredentials()) {
            this.applyCredentials(builder);
        }
        String host = this.getOrDefault(this.properties.getHost(), "localhost");
        int port = this.getOrDefault(this.properties.getPort(), 27017);
        ServerAddress serverAddress = new ServerAddress(host, port);
        builder.clusterSettings(ClusterSettings.builder().hosts(Collections.singletonList(serverAddress)).build());
        return this.createMongoClient(builder);
    }

    private void applyCredentials(MongoClientSettings.Builder builder) {
        String database = this.properties.getAuthenticationDatabase() != null ? this.properties.getAuthenticationDatabase() : this.properties.getMongoClientDatabase();
        builder.credential(MongoCredential.createCredential((String)this.properties.getUsername(), (String)database, (char[])this.properties.getPassword()));
    }

    private <T> T getOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    private MongoClient createMongoClient(MongoClientSettings.Builder builder) {
        this.customize(builder);
        return MongoClients.create((MongoClientSettings)builder.build());
    }

    private MongoClientSettings.Builder createBuilder(MongoClientSettings settings, ConnectionString connection) {
        MongoClientSettings.Builder builder = this.builder(settings);
        builder.clusterSettings(this.getClusterSettings(connection));
        builder.connectionPoolSettings(this.getConnectionPoolSettings(connection));
        builder.serverSettings(this.getServerSettings(connection));
        if (connection.getCredential() != null) {
            builder.credential(connection.getCredential());
        }
        builder.sslSettings(this.getSslSettings(connection));
        builder.socketSettings(this.getSocketSettings(connection));
        if (connection.getReadPreference() != null) {
            builder.readPreference(connection.getReadPreference());
        }
        if (connection.getReadConcern() != null) {
            builder.readConcern(connection.getReadConcern());
        }
        if (connection.getWriteConcern() != null) {
            builder.writeConcern(connection.getWriteConcern());
        }
        if (connection.getApplicationName() != null) {
            builder.applicationName(connection.getApplicationName());
        }
        return builder;
    }

    private ClusterSettings getClusterSettings(ConnectionString connection) {
        return ClusterSettings.builder().applyConnectionString(connection).build();
    }

    private ConnectionPoolSettings getConnectionPoolSettings(ConnectionString connection) {
        return ConnectionPoolSettings.builder().applyConnectionString(connection).build();
    }

    private ServerSettings getServerSettings(ConnectionString connection) {
        return ServerSettings.builder().applyConnectionString(connection).build();
    }

    private SslSettings getSslSettings(ConnectionString connection) {
        return SslSettings.builder().applyConnectionString(connection).build();
    }

    private SocketSettings getSocketSettings(ConnectionString connection) {
        return SocketSettings.builder().applyConnectionString(connection).build();
    }

    private void customize(MongoClientSettings.Builder builder) {
        for (MongoClientSettingsBuilderCustomizer customizer2 : this.builderCustomizers) {
            customizer2.customize(builder);
        }
    }

    private boolean hasCustomAddress() {
        return this.properties.getHost() != null || this.properties.getPort() != null;
    }

    private boolean hasCustomCredentials() {
        return this.properties.getUsername() != null && this.properties.getPassword() != null;
    }

    private MongoClientSettings.Builder builder(MongoClientSettings settings) {
        if (settings == null) {
            return MongoClientSettings.builder();
        }
        return MongoClientSettings.builder((MongoClientSettings)settings);
    }
}

