/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import io.micrometer.core.instrument.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

public final class WebMvcTags {
    private static final Tag URI_NOT_FOUND = Tag.of("uri", "NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of("uri", "REDIRECTION");
    private static final Tag URI_UNKNOWN = Tag.of("uri", "UNKNOWN");
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Tag STATUS_UNKNOWN = Tag.of("status", "UNKNOWN");
    private static final Tag METHOD_UNKNOWN = Tag.of("method", "UNKNOWN");

    private WebMvcTags() {
    }

    public static Tag method(HttpServletRequest request) {
        return request != null ? Tag.of("method", request.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag status(HttpServletResponse response) {
        return response != null ? Tag.of("status", Integer.toString(response.getStatus())) : STATUS_UNKNOWN;
    }

    public static Tag uri(HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            String pathInfo;
            String pattern = WebMvcTags.getMatchingPattern(request);
            if (pattern != null) {
                return Tag.of("uri", pattern);
            }
            if (response != null) {
                HttpStatus status = WebMvcTags.extractStatus(response);
                if (status != null && status.is3xxRedirection()) {
                    return URI_REDIRECTION;
                }
                if (status != null && status.equals((Object)HttpStatus.NOT_FOUND)) {
                    return URI_NOT_FOUND;
                }
            }
            return Tag.of("uri", (pathInfo = WebMvcTags.getPathInfo(request)).isEmpty() ? "root" : pathInfo);
        }
        return URI_UNKNOWN;
    }

    private static HttpStatus extractStatus(HttpServletResponse response) {
        try {
            return HttpStatus.valueOf(response.getStatus());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static String getMatchingPattern(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
    }

    private static String getPathInfo(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String uri = StringUtils.hasText(pathInfo) ? pathInfo : "/";
        return uri.replaceAll("//+", "/").replaceAll("/$", "");
    }

    public static Tag exception(Throwable exception) {
        return exception != null ? Tag.of("exception", exception.getClass().getSimpleName()) : EXCEPTION_NONE;
    }
}

