/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

public final class WebFluxTags {
    private static final Tag URI_NOT_FOUND = Tag.of("uri", "NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of("uri", "REDIRECTION");

    private WebFluxTags() {
    }

    public static Tag method(ServerWebExchange exchange2) {
        return Tag.of("method", exchange2.getRequest().getMethod().toString());
    }

    public static Tag status(ServerWebExchange exchange2) {
        HttpStatus status = exchange2.getResponse().getStatusCode();
        if (status == null) {
            status = HttpStatus.OK;
        }
        return Tag.of("status", status.toString());
    }

    public static Tag uri(ServerWebExchange exchange2) {
        if (exchange2 != null) {
            PathPattern pathPattern = (PathPattern)exchange2.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            if (pathPattern != null) {
                return Tag.of("uri", pathPattern.getPatternString());
            }
            HttpStatus status = exchange2.getResponse().getStatusCode();
            if (status != null && status.is3xxRedirection()) {
                return URI_REDIRECTION;
            }
            if (status != null && status.equals((Object)HttpStatus.NOT_FOUND)) {
                return URI_NOT_FOUND;
            }
            String path = exchange2.getRequest().getPath().value();
            return Tag.of("uri", path.isEmpty() ? "root" : path);
        }
        return Tag.of("uri", "UNKNOWN");
    }

    public static Tag exception(Throwable exception) {
        if (exception != null) {
            return Tag.of("exception", exception.getClass().getSimpleName());
        }
        return Tag.of("exception", "none");
    }
}

