/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider;
import org.springframework.boot.actuate.metrics.cache.CacheMetricsRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={CacheMeterBinderProvider.class, MeterRegistry.class})
class CacheMetricsRegistrarConfiguration {
    private static final String CACHE_MANAGER_SUFFIX = "cacheManager";
    private final MeterRegistry registry;
    private final Collection<CacheMeterBinderProvider<?>> binderProviders;
    private final Map<String, CacheManager> cacheManagers;

    CacheMetricsRegistrarConfiguration(MeterRegistry registry, Collection<CacheMeterBinderProvider<?>> binderProviders, Map<String, CacheManager> cacheManagers) {
        this.registry = registry;
        this.binderProviders = binderProviders;
        this.cacheManagers = cacheManagers;
    }

    @Bean
    public CacheMetricsRegistrar cacheMetricsRegistrar() {
        return new CacheMetricsRegistrar(this.registry, this.binderProviders);
    }

    @PostConstruct
    public void bindCachesToRegistry() {
        this.cacheManagers.forEach(this::bindCacheManagerToRegistry);
    }

    private void bindCacheManagerToRegistry(String beanName, CacheManager cacheManager) {
        cacheManager.getCacheNames().forEach(cacheName -> this.bindCacheToRegistry(beanName, cacheManager.getCache((String)cacheName)));
    }

    private void bindCacheToRegistry(String beanName, Cache cache) {
        Tag cacheManagerTag = Tag.of(CACHE_MANAGER_SUFFIX, this.getCacheManagerName(beanName));
        this.cacheMetricsRegistrar().bindCacheToRegistry(cache, cacheManagerTag);
    }

    private String getCacheManagerName(String beanName) {
        if (beanName.length() > CACHE_MANAGER_SUFFIX.length() && StringUtils.endsWithIgnoreCase(beanName, CACHE_MANAGER_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CACHE_MANAGER_SUFFIX.length());
        }
        return beanName;
    }
}

