/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.amqp;

import com.rabbitmq.client.ConnectionFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.amqp.RabbitMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, RabbitAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, AbstractConnectionFactory.class})
@ConditionalOnBean(value={AbstractConnectionFactory.class, MeterRegistry.class})
public class RabbitMetricsAutoConfiguration {
    private static final String CONNECTION_FACTORY_SUFFIX = "connectionFactory";
    private final MeterRegistry registry;

    public RabbitMetricsAutoConfiguration(MeterRegistry registry) {
        this.registry = registry;
    }

    @Autowired
    public void bindConnectionFactoriesToRegistry(Map<String, AbstractConnectionFactory> connectionFactories) {
        connectionFactories.forEach(this::bindConnectionFactoryToRegistry);
    }

    private void bindConnectionFactoryToRegistry(String beanName, AbstractConnectionFactory connectionFactory) {
        ConnectionFactory rabbitConnectionFactory = connectionFactory.getRabbitConnectionFactory();
        String connectionFactoryName = this.getConnectionFactoryName(beanName);
        new RabbitMetrics(rabbitConnectionFactory, Tags.of("name", connectionFactoryName)).bindTo(this.registry);
    }

    private String getConnectionFactoryName(String beanName) {
        if (beanName.length() > CONNECTION_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase(beanName, CONNECTION_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CONNECTION_FACTORY_SUFFIX.length());
        }
        return beanName;
    }
}

