/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class MeterRegistryConfigurer {
    private final Collection<MeterRegistryCustomizer<?>> customizers;
    private final Collection<MeterFilter> filters;
    private final Collection<MeterBinder> binders;
    private final boolean addToGlobalRegistry;

    MeterRegistryConfigurer(Collection<MeterBinder> binders, Collection<MeterFilter> filters, Collection<MeterRegistryCustomizer<?>> customizers, boolean addToGlobalRegistry) {
        this.binders = binders != null ? binders : Collections.emptyList();
        this.filters = filters != null ? filters : Collections.emptyList();
        this.customizers = customizers != null ? customizers : Collections.emptyList();
        this.addToGlobalRegistry = addToGlobalRegistry;
    }

    void configure(MeterRegistry registry) {
        this.customize(registry);
        this.addFilters(registry);
        this.addBinders(registry);
        if (this.addToGlobalRegistry && registry != Metrics.globalRegistry) {
            Metrics.addRegistry(registry);
        }
    }

    private void customize(MeterRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(MeterRegistryCustomizer.class, this.customizers, registry, new Object[0]).withLogger(MeterRegistryConfigurer.class)).invoke(customizer2 -> customizer2.customize(registry));
    }

    private void addFilters(MeterRegistry registry) {
        this.filters.forEach(registry.config()::meterFilter);
    }

    private void addBinders(MeterRegistry registry) {
        this.binders.forEach(binder -> binder.bindTo(registry));
    }
}

