/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeReactiveHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.core.ResolvableType;

public abstract class CompositeReactiveHealthIndicatorConfiguration<H extends ReactiveHealthIndicator, S> {
    @Autowired
    private HealthAggregator healthAggregator;

    protected ReactiveHealthIndicator createHealthIndicator(Map<String, S> beans2) {
        if (beans2.size() == 1) {
            return this.createHealthIndicator(beans2.values().iterator().next());
        }
        CompositeReactiveHealthIndicator composite = new CompositeReactiveHealthIndicator(this.healthAggregator);
        beans2.forEach((name, source) -> composite.addHealthIndicator((String)name, (ReactiveHealthIndicator)this.createHealthIndicator(source)));
        return composite;
    }

    protected H createHealthIndicator(S source) {
        Class<?>[] generics = ResolvableType.forClass(CompositeReactiveHealthIndicatorConfiguration.class, this.getClass()).resolveGenerics();
        Class<?> indicatorClass = generics[0];
        Class<?> sourceClass = generics[1];
        try {
            return (H)((ReactiveHealthIndicator)indicatorClass.getConstructor(sourceClass).newInstance(source));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create indicator " + indicatorClass + " for source " + sourceClass, ex);
        }
    }
}

