/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Optional;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private static final ConcurrentReferenceHashMap<Environment, Optional<Boolean>> enabledByDefaultCache = new ConcurrentReferenceHashMap();

    OnEnabledEndpointCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment2 = context.getEnvironment();
        AnnotationAttributes attributes = this.getEndpointAttributes(context, metadata);
        String id = attributes.getString("id");
        String key = "management.endpoint." + id + ".enabled";
        Boolean userDefinedEnabled = environment2.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome((boolean)userDefinedEnabled, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, new Object[0]).because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = this.isEnabledByDefault(environment2);
        if (userDefinedDefault != null) {
            return new ConditionOutcome((boolean)userDefinedDefault, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, new Object[0]).because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = attributes.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, new Object[0]).because("no property " + key + " found so using endpoint default"));
    }

    private Boolean isEnabledByDefault(Environment environment2) {
        Optional<Boolean> enabledByDefault = enabledByDefaultCache.get(environment2);
        if (enabledByDefault == null) {
            enabledByDefault = Optional.ofNullable(environment2.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class));
            enabledByDefaultCache.put(environment2, enabledByDefault);
        }
        return enabledByDefault.orElse(null);
    }

    private AnnotationAttributes getEndpointAttributes(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Assert.state(metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()), "OnEnabledEndpointCondition may only be used on @Bean methods");
        return this.getEndpointAttributes(context, (MethodMetadata)metadata);
    }

    private AnnotationAttributes getEndpointAttributes(ConditionContext context, MethodMetadata metadata) {
        try {
            Class<?> returnType = ClassUtils.forName(metadata.getReturnTypeName(), context.getClassLoader());
            return this.getEndpointAttributes(returnType);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + metadata.getDeclaringClassName() + "." + metadata.getMethodName(), ex);
        }
    }

    protected AnnotationAttributes getEndpointAttributes(Class<?> type) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, Endpoint.class, true, true);
        if (attributes != null) {
            return attributes;
        }
        attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, EndpointExtension.class, false, true);
        Assert.state(attributes != null, "OnEnabledEndpointCondition may only be used on @Bean methods that return an @Endpoint or @EndpointExtension");
        return this.getEndpointAttributes(attributes.getClass("endpoint"));
    }
}

