/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryWebEndpointDiscoverer;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryWebEndpointServletHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.TokenValidator;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ServletManagementContextAutoConfiguration;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnProperty(prefix="management.cloudfoundry", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={ServletManagementContextAutoConfiguration.class, HealthEndpointAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={DispatcherServlet.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class CloudFoundryActuatorAutoConfiguration {
    private final ApplicationContext applicationContext;

    CloudFoundryActuatorAutoConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    @ConditionalOnBean(value={HealthEndpoint.class, HealthEndpointWebExtension.class})
    public CloudFoundryHealthEndpointWebExtension cloudFoundryHealthEndpointWebExtension(HealthEndpointWebExtension healthEndpointWebExtension) {
        return new CloudFoundryHealthEndpointWebExtension(healthEndpointWebExtension);
    }

    @Bean
    public CloudFoundryWebEndpointServletHandlerMapping cloudFoundryWebEndpointServletHandlerMapping(ParameterValueMapper parameterMapper, EndpointMediaTypes endpointMediaTypes, RestTemplateBuilder restTemplateBuilder, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier) {
        CloudFoundryWebEndpointDiscoverer discoverer = new CloudFoundryWebEndpointDiscoverer(this.applicationContext, parameterMapper, endpointMediaTypes, PathMapper.useEndpointId(), Collections.emptyList(), Collections.emptyList());
        CloudFoundrySecurityInterceptor securityInterceptor = this.getSecurityInterceptor(restTemplateBuilder, this.applicationContext.getEnvironment());
        Collection<ExposableWebEndpoint> webEndpoints = discoverer.getEndpoints();
        ArrayList<ExposableWebEndpoint> allEndpoints = new ArrayList<ExposableWebEndpoint>();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new CloudFoundryWebEndpointServletHandlerMapping(new EndpointMapping("/cloudfoundryapplication"), webEndpoints, endpointMediaTypes, this.getCorsConfiguration(), securityInterceptor, new EndpointLinksResolver(allEndpoints));
    }

    private CloudFoundrySecurityInterceptor getSecurityInterceptor(RestTemplateBuilder restTemplateBuilder, Environment environment2) {
        CloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(restTemplateBuilder, environment2);
        TokenValidator tokenValidator = new TokenValidator(cloudfoundrySecurityService);
        return new CloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment2.getProperty("vcap.application.application_id"));
    }

    private CloudFoundrySecurityService getCloudFoundrySecurityService(RestTemplateBuilder restTemplateBuilder, Environment environment2) {
        String cloudControllerUrl = environment2.getProperty("vcap.application.cf_api");
        boolean skipSslValidation = environment2.getProperty("management.cloudfoundry.skip-ssl-validation", Boolean.class, false);
        return cloudControllerUrl != null ? new CloudFoundrySecurityService(restTemplateBuilder, cloudControllerUrl, skipSslValidation) : null;
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    @ConditionalOnClass(value={WebSecurity.class})
    @Order(value=-2147483648)
    @Configuration
    public static class IgnoredPathsWebSecurityConfigurer
    implements WebSecurityConfigurer<WebSecurity> {
        @Override
        public void init(WebSecurity builder) throws Exception {
            builder.ignoring().requestMatchers(new AntPathRequestMatcher("/cloudfoundryapplication/**"));
        }

        @Override
        public void configure(WebSecurity builder) throws Exception {
        }
    }
}

