/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveFragment;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHaveParameter;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveScheme;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Uris {
    private static final String UTF_8 = "UTF-8";
    private static final String EQUAL = "=";
    private static final String AND = "&";
    private static final Uris INSTANCE = new Uris();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Uris instance() {
        return INSTANCE;
    }

    Uris() {
    }

    public void assertHasScheme(AssertionInfo info, URI actual, String scheme) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getScheme(), scheme)) {
            throw this.failures.failure(info, ShouldHaveScheme.shouldHaveScheme(actual, scheme));
        }
    }

    public void assertHasPath(AssertionInfo info, URI actual, String path) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getPath(), path)) {
            throw this.failures.failure(info, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info, URI actual, Integer expected) {
        Comparables.assertNotNull(info, actual);
        if (actual.getPort() != expected.intValue()) {
            throw this.failures.failure(info, ShouldHavePort.shouldHavePort(actual, (int)expected));
        }
    }

    public void assertHasHost(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getHost(), expected)) {
            throw this.failures.failure(info, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasAuthority(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getAuthority(), expected)) {
            throw this.failures.failure(info, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasFragment(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getFragment(), expected)) {
            throw this.failures.failure(info, ShouldHaveFragment.shouldHaveFragment(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getQuery(), expected)) {
            throw this.failures.failure(info, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }

    @VisibleForTesting
    public static Map<String, List<String>> getParameters(String query2) {
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
        if (query2 != null && !query2.isEmpty()) {
            for (String pair : query2.split(AND)) {
                int equalIndex = pair.indexOf(EQUAL);
                String key = equalIndex == -1 ? pair : pair.substring(0, equalIndex);
                String value = equalIndex == -1 ? null : pair.substring(equalIndex + 1);
                try {
                    key = URLDecoder.decode(key, UTF_8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (value != null) {
                    try {
                        value = URLDecoder.decode(value, UTF_8);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (!parameters.containsKey(key)) {
                    parameters.put(key, new ArrayList());
                }
                ((List)parameters.get(key)).add(value);
            }
        }
        return parameters;
    }

    public void assertHasParameter(AssertionInfo info, URI actual, String name) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(name)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, name));
        }
    }

    public void assertHasParameter(AssertionInfo info, URI actual, String expectedParameterName, String expectedParameterValue) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.containsKey(expectedParameterName)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue));
        }
        List<String> values = parameters.get(expectedParameterName);
        if (!values.contains(expectedParameterValue)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue, values));
        }
    }

    public void assertHasNoParameters(AssertionInfo info, URI actual) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (!parameters.isEmpty()) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameters(actual, parameters.keySet()));
        }
    }

    public void assertHasNoParameter(AssertionInfo info, URI actual, String name) {
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameter(actual, name, parameters.get(name)));
        }
    }

    public void assertHasNoParameter(AssertionInfo info, URI actual, String name, String unwantedValue) {
        List<String> values;
        Comparables.assertNotNull(info, actual);
        Map<String, List<String>> parameters = Uris.getParameters(actual.getQuery());
        if (parameters.containsKey(name) && (values = parameters.get(name)).contains(unwantedValue)) {
            throw this.failures.failure(info, ShouldHaveParameter.shouldHaveNoParameter(actual, name, unwantedValue, values));
        }
    }
}

