/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.data.Offset;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldBeEqualWithinOffset
extends BasicErrorMessageFactory {
    public static <T extends Number> ErrorMessageFactory shouldBeEqual(T actual, T expected, Offset<T> offset, T difference) {
        return offset.strict ? new ShouldBeEqualWithinOffset(actual, expected, offset, difference) : new ShouldBeEqualWithinOffset(actual, expected, offset, difference);
    }

    private <T extends Number> ShouldBeEqualWithinOffset(Number actual, Number expected, Offset<T> offset, Number difference) {
        super("%nExpecting:%n  <%s>%nto be close to:%n  <%s>%nby less than <%s> but difference was <%s>.%n(a difference of exactly <%s> being considered " + ShouldBeEqualWithinOffset.validOrNot(offset) + ")", actual, expected, offset.value, difference, offset.value);
    }

    private static <T extends Number> String validOrNot(Offset<T> offset) {
        return offset.strict ? "invalid" : "valid";
    }
}

