/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Utility;

public final class Synthetic
extends Attribute {
    private byte[] bytes;

    public Synthetic(Synthetic synthetic) {
        this(synthetic.getNameIndex(), synthetic.getLength(), synthetic.getBytes(), synthetic.getConstantPool());
    }

    public Synthetic(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)7, n, n2, constantPool);
        this.bytes = byArray;
    }

    Synthetic(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInputStream.readFully(this.bytes);
            System.err.println("Synthetic attribute with length > 0");
        }
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitSynthetic(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.length > 0) {
            dataOutputStream.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("Synthetic");
        if (this.length > 0) {
            stringBuffer.append(" " + Utility.toHexString(this.bytes));
        }
        return stringBuffer.toString();
    }
}

