/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.ArithmeticException;
import io.mosip.kernel.core.exception.IllegalArgumentException;
import io.mosip.kernel.core.exception.NullPointerException;
import io.mosip.kernel.core.util.constant.MathUtilConstants;
import io.mosip.kernel.core.util.exception.NotANumberException;
import io.mosip.kernel.core.util.exception.NotFiniteNumberException;
import io.mosip.kernel.core.util.exception.NotPositiveException;
import io.mosip.kernel.core.util.exception.NumberIsTooLargeException;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.primes.Primes;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

public final class MathUtils {
    private MathUtils() {
    }

    public static int getPow(int num, int exp) {
        try {
            return ArithmeticUtils.pow(num, exp);
        }
        catch (org.apache.commons.math3.exception.NotPositiveException e) {
            throw new NotPositiveException(MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getErrorCode(), MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (MathArithmeticException e) {
            throw new ArithmeticException(MathUtilConstants.ARITHMETIC_ERROR_CODE.getErrorCode(), MathUtilConstants.ARITHMETIC_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getPow(double num, double exp) {
        return FastMath.pow(num, exp);
    }

    public static long getPow(long num, int exp) {
        try {
            return ArithmeticUtils.pow(num, exp);
        }
        catch (org.apache.commons.math3.exception.NotPositiveException e) {
            throw new NotPositiveException(MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getErrorCode(), MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (MathArithmeticException e) {
            throw new ArithmeticException(MathUtilConstants.ARITHMETIC_ERROR_CODE.getErrorCode(), MathUtilConstants.ARITHMETIC_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static BigInteger getPow(BigInteger num, int exp) {
        try {
            return ArithmeticUtils.pow(num, exp);
        }
        catch (org.apache.commons.math3.exception.NotPositiveException e) {
            throw new NotPositiveException(MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getErrorCode(), MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(MathUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), MathUtilConstants.NULL_POINTER_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static BigInteger getPow(BigInteger num, BigInteger exp) {
        try {
            return ArithmeticUtils.pow(num, exp);
        }
        catch (org.apache.commons.math3.exception.NotPositiveException e) {
            throw new NotPositiveException(MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getErrorCode(), MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(MathUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), MathUtilConstants.NULL_POINTER_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static int getRandom(int lowerlimit, int upperlimit) {
        try {
            return new RandomDataGenerator().nextInt(lowerlimit, upperlimit);
        }
        catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
            throw new NumberIsTooLargeException(MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getErrorCode(), MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static long getRandom(long lowerlimit, long upperlimit) {
        try {
            return new RandomDataGenerator().nextLong(lowerlimit, upperlimit);
        }
        catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
            throw new NumberIsTooLargeException(MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getErrorCode(), MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getRandom(double lowerlimit, double upperlimit) {
        try {
            return new RandomDataGenerator().nextUniform(lowerlimit, upperlimit);
        }
        catch (org.apache.commons.math3.exception.NumberIsTooLargeException e) {
            throw new NumberIsTooLargeException(MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getErrorCode(), MathUtilConstants.NUMBER_IS_TOO_LARGE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (org.apache.commons.math3.exception.NotFiniteNumberException e) {
            throw new NotFiniteNumberException(MathUtilConstants.NOT_FINITE_NUMBER_ERROR_CODE.getErrorCode(), MathUtilConstants.NOT_FINITE_NUMBER_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (org.apache.commons.math3.exception.NotANumberException e) {
            throw new NotANumberException(MathUtilConstants.NOT_A_NUMBER_ERROR_CODE.getErrorCode(), MathUtilConstants.NOT_A_NUMBER_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static float getRandom(float lowerlimit, float upperlimit) {
        float randomFloat = new RandomDataGenerator().getRandomGenerator().nextFloat();
        return lowerlimit + randomFloat * (upperlimit - lowerlimit);
    }

    public static final double getSqrt(double num) {
        return FastMath.sqrt(num);
    }

    public static final int getMax(int firstnumber, int secondnumber) {
        return FastMath.max(firstnumber, secondnumber);
    }

    public static final double getMax(double firstnumber, double secondnumber) {
        return FastMath.max(firstnumber, secondnumber);
    }

    public static final double getRound(double num, int place) {
        return Precision.round(num, place);
    }

    public static final float getRound(float num, int place) {
        return Precision.round(num, place);
    }

    public static final long getRound(double num) {
        return FastMath.round(num);
    }

    public static final double getAbs(double num) {
        return FastMath.abs(num);
    }

    public static final float getAbs(float num) {
        return FastMath.abs(num);
    }

    public static final long getAbs(long num) {
        return FastMath.abs(num);
    }

    public static final int getAbs(int num) {
        return FastMath.abs(num);
    }

    public static final long getFactorial(int number) {
        try {
            return CombinatoricsUtils.factorial(number);
        }
        catch (org.apache.commons.math3.exception.NotPositiveException e) {
            throw new NotPositiveException(MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getErrorCode(), MathUtilConstants.NOTPOSITIVE_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
        catch (MathArithmeticException e) {
            throw new ArithmeticException(MathUtilConstants.ARITHMETIC_ERROR_CODE.getErrorCode(), MathUtilConstants.ARITHMETIC_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static final int getGcd(int firstnumber, int secondnumber) {
        try {
            return ArithmeticUtils.gcd(firstnumber, secondnumber);
        }
        catch (MathArithmeticException e) {
            throw new ArithmeticException(MathUtilConstants.ARITHMETIC_ERROR_CODE.getErrorCode(), MathUtilConstants.ARITHMETIC_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static final long getGcd(long firstnumber, long secondnumber) {
        try {
            return ArithmeticUtils.gcd(firstnumber, secondnumber);
        }
        catch (MathArithmeticException e) {
            throw new ArithmeticException(MathUtilConstants.ARITHMETIC_ERROR_CODE.getErrorCode(), MathUtilConstants.ARITHMETIC_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static final double getLog(double num) {
        return FastMath.log(num);
    }

    public static final double getLog10(double num) {
        return FastMath.log10(num);
    }

    public static int[] getCopyOfArray(int[] source) {
        return MathArrays.copyOf(source);
    }

    public static int[] getCopyOfArray(int[] source, int length) {
        return MathArrays.copyOf(source, length);
    }

    public static double[] getCopyOfArray(double[] source) {
        return MathArrays.copyOf(source);
    }

    public static double[] getCopyOfArray(double[] source, int length) {
        return MathArrays.copyOf(source, length);
    }

    public static double getArrayMaxValue(double[] arr) {
        try {
            return StatUtils.max(arr);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayMaxValue(double[] arr, int startindex, int length) {
        try {
            return StatUtils.max(arr, startindex, length);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayMinValue(double[] arr) {
        try {
            return StatUtils.min(arr);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayMinValue(double[] arr, int startindex, int length) {
        try {
            return StatUtils.min(arr, startindex, length);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesSum(double[] arr) {
        try {
            return StatUtils.sum(arr);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesSum(double[] arr, int startindex, int length) {
        try {
            return StatUtils.sum(arr, startindex, length);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesProduct(double[] arr) {
        try {
            return StatUtils.product(arr);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesProduct(double[] arr, int startindex, int length) {
        try {
            return StatUtils.product(arr, startindex, length);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesMean(double[] arr) {
        try {
            return StatUtils.mean(arr);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double getArrayValuesMean(double[] arr, int startindex, int length) {
        try {
            return StatUtils.mean(arr, startindex, length);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static boolean isPrimeOrNot(int num) {
        return Primes.isPrime(num);
    }

    public static int nextPrimeNumber(int num) {
        try {
            return Primes.nextPrime(num);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static List<Integer> getPrimeFactors(int num) {
        try {
            return Primes.primeFactors(num);
        }
        catch (MathIllegalArgumentException e) {
            throw new IllegalArgumentException(MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getErrorCode(), MathUtilConstants.ILLEGALARGUMENT_ERROR_CODE.getEexceptionMessage(), e.getCause());
        }
    }

    public static double ceil(double num) {
        return FastMath.ceil(num);
    }

    public static double floor(double num) {
        return FastMath.floor(num);
    }
}

