/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.crypto.constant.CryptoExceptionCodeConstants;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.core.util.HMACUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;

public class CryptoUtil {
    private static final String SYMMETRIC_ALGORITHM = "AES/GCM/PKCS5Padding";
    private static final String AES = "AES";
    private static final int TAG_LENGTH = 128;
    private static SecureRandom secureRandom;
    private static Base64.Encoder urlSafeEncoder;

    private CryptoUtil() {
    }

    public static byte[] combineByteArray(byte[] data, byte[] key, String keySplitter) {
        byte[] keySplitterBytes = keySplitter.getBytes();
        byte[] combinedArray = new byte[key.length + keySplitterBytes.length + data.length];
        System.arraycopy(key, 0, combinedArray, 0, key.length);
        System.arraycopy(keySplitterBytes, 0, combinedArray, key.length, keySplitterBytes.length);
        System.arraycopy(data, 0, combinedArray, key.length + keySplitterBytes.length, data.length);
        return combinedArray;
    }

    public static int getSplitterIndex(byte[] encryptedData, int keyDemiliterIndex, String keySplitter) {
        String keySplit;
        byte data;
        byte keySplitterFirstByte = keySplitter.getBytes()[0];
        int keySplitterLength = keySplitter.length();
        byte[] byArray = encryptedData;
        int n = byArray.length;
        for (int i = 0; !(i >= n || (data = byArray[i]) == keySplitterFirstByte && keySplitter.equals(keySplit = new String(Arrays.copyOfRange(encryptedData, keyDemiliterIndex, keyDemiliterIndex + keySplitterLength)))); ++i) {
            ++keyDemiliterIndex;
        }
        return keyDemiliterIndex;
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static String encodeBase64(byte[] data) {
        return urlSafeEncoder.encodeToString(data);
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static String encodeBase64String(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static byte[] decodeBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        try {
            return Base64.getUrlDecoder().decode(data);
        }
        catch (IllegalArgumentException exception) {
            return Base64.getDecoder().decode(data);
        }
    }

    public static String encodeToURLSafeBase64(byte[] data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return urlSafeEncoder.encodeToString(data);
    }

    public static byte[] decodeURLSafeBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getUrlDecoder().decode(data);
    }

    public static String encodeToPlainBase64(byte[] data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodePlainBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getDecoder().decode(data);
    }

    public static String computeFingerPrint(String data, String metaData) {
        return CryptoUtil.computeFingerPrint(data.getBytes(), metaData);
    }

    public static String computeFingerPrint(byte[] data, String metaData) {
        byte[] combinedPlainTextBytes = null;
        combinedPlainTextBytes = EmptyCheckUtils.isNullEmpty(metaData) ? ArrayUtils.addAll(data, new byte[0]) : ArrayUtils.addAll(data, metaData.getBytes());
        return Hex.encodeHexString(HMACUtils.generateHash(combinedPlainTextBytes)).replaceAll("..(?!$)", "$0:");
    }

    public static byte[] symmetricEncrypt(SecretKey key, byte[] data) {
        Cipher cipher;
        Objects.requireNonNull(key, CryptoExceptionCodeConstants.INVALID_KEY_EXCEPTION.getErrorMessage());
        if (Objects.isNull(data) || data.length == 0) {
            throw new NullDataException(CryptoExceptionCodeConstants.INVALID_DATA_EXCEPTION.getErrorCode(), CryptoExceptionCodeConstants.INVALID_DATA_EXCEPTION.getErrorMessage());
        }
        try {
            cipher = Cipher.getInstance(SYMMETRIC_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new io.mosip.kernel.core.crypto.exception.NoSuchAlgorithmException(CryptoExceptionCodeConstants.NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), CryptoExceptionCodeConstants.NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), e);
        }
        try {
            byte[] output = null;
            byte[] randomIV = CryptoUtil.generateIV(cipher.getBlockSize());
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), AES);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, randomIV);
            cipher.init(1, (Key)keySpec, gcmParameterSpec);
            output = new byte[cipher.getOutputSize(data.length) + cipher.getBlockSize()];
            byte[] processData = cipher.doFinal(data);
            System.arraycopy(processData, 0, output, 0, processData.length);
            System.arraycopy(randomIV, 0, output, processData.length, randomIV.length);
            return output;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(CryptoExceptionCodeConstants.INVALID_KEY_EXCEPTION.getErrorCode(), CryptoExceptionCodeConstants.INVALID_KEY_EXCEPTION.getErrorMessage(), e);
        }
    }

    private static byte[] generateIV(int blockSize) {
        byte[] byteIV = new byte[blockSize];
        if (Objects.isNull(secureRandom)) {
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(byteIV);
        return byteIV;
    }

    static {
        urlSafeEncoder = Base64.getUrlEncoder().withoutPadding();
    }
}

