/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.retry;

import io.mosip.kernel.core.util.RetryUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RetryAspect {
    @Autowired
    private RetryUtil retryUtil;

    @Pointcut(value="@annotation(WithRetry)")
    public void withRetryMethods() {
    }

    @Around(value="withRetryMethods()")
    public Object processMethodsWithRetry(ProceedingJoinPoint pjp) throws Throwable {
        return this.retryUtil.doWithRetry(() -> pjp.proceed());
    }
}

