/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.TokenUtils;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Header;
import com.auth0.jwt.interfaces.Payload;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

final class JWTDecoder
implements DecodedJWT {
    private final String[] parts;
    private final Header header;
    private final Payload payload;

    JWTDecoder(String jwt) throws JWTDecodeException {
        this(new JWTParser(), jwt);
    }

    JWTDecoder(JWTParser converter, String jwt) throws JWTDecodeException {
        String payloadJson;
        String headerJson;
        this.parts = TokenUtils.splitToken(jwt);
        try {
            headerJson = StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[0]));
            payloadJson = StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[1]));
        }
        catch (NullPointerException e) {
            throw new JWTDecodeException("The UTF-8 Charset isn't initialized.", e);
        }
        this.header = converter.parseHeader(headerJson);
        this.payload = converter.parsePayload(payloadJson);
    }

    @Override
    public String getAlgorithm() {
        return this.header.getAlgorithm();
    }

    @Override
    public String getType() {
        return this.header.getType();
    }

    @Override
    public String getContentType() {
        return this.header.getContentType();
    }

    @Override
    public String getKeyId() {
        return this.header.getKeyId();
    }

    @Override
    public Claim getHeaderClaim(String name) {
        return this.header.getHeaderClaim(name);
    }

    @Override
    public String getIssuer() {
        return this.payload.getIssuer();
    }

    @Override
    public String getSubject() {
        return this.payload.getSubject();
    }

    @Override
    public List<String> getAudience() {
        return this.payload.getAudience();
    }

    @Override
    public Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    @Override
    public Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    @Override
    public Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    @Override
    public String getId() {
        return this.payload.getId();
    }

    @Override
    public Claim getClaim(String name) {
        return this.payload.getClaim(name);
    }

    @Override
    public Map<String, Claim> getClaims() {
        return this.payload.getClaims();
    }

    @Override
    public String getHeader() {
        return this.parts[0];
    }

    @Override
    public String getPayload() {
        return this.parts[1];
    }

    @Override
    public String getSignature() {
        return this.parts[2];
    }

    @Override
    public String getToken() {
        return String.format("%s.%s.%s", this.parts[0], this.parts[1], this.parts[2]);
    }
}

