/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.http.HttpTracing;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;

abstract class WebMvcRuntime {
    private static final WebMvcRuntime WEBMVC_RUNTIME = WebMvcRuntime.findWebMvcRuntime();

    abstract HttpTracing httpTracing(ApplicationContext var1);

    abstract boolean isHandlerMethod(Object var1);

    WebMvcRuntime() {
    }

    static WebMvcRuntime get() {
        return WEBMVC_RUNTIME;
    }

    static WebMvcRuntime findWebMvcRuntime() {
        try {
            Class.forName("org.springframework.web.method.HandlerMethod");
            return new WebMvc31();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new WebMvc25();
        }
    }

    static final class WebMvc25
    extends WebMvcRuntime {
        WebMvc25() {
        }

        @Override
        HttpTracing httpTracing(ApplicationContext ctx) {
            Object bean2;
            if (ctx.containsBean("httpTracing") && (bean2 = ctx.getBean("httpTracing")) instanceof HttpTracing) {
                return (HttpTracing)bean2;
            }
            throw new NoSuchBeanDefinitionException(HttpTracing.class, "httpTracing");
        }

        @Override
        boolean isHandlerMethod(Object handler) {
            return false;
        }
    }

    static final class WebMvc31
    extends WebMvcRuntime {
        WebMvc31() {
        }

        @Override
        HttpTracing httpTracing(ApplicationContext ctx) {
            return ctx.getBean(HttpTracing.class);
        }

        @Override
        boolean isHandlerMethod(Object handler) {
            return handler instanceof HandlerMethod;
        }
    }
}

