/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class TracingAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    final Tracer tracer;
    final HttpClientHandler<HttpRequest, ClientHttpResponse> handler;
    final TraceContext.Injector<HttpHeaders> injector;

    public static AsyncClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingAsyncClientHttpRequestInterceptor.create(HttpTracing.create(tracing));
    }

    public static AsyncClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingAsyncClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingAsyncClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create(httpTracing, new TracingClientHttpRequestInterceptor.HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(TracingClientHttpRequestInterceptor.SETTER);
    }

    @Override
    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        Span span = this.handler.handleSend(this.injector, request.getHeaders(), request);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            ListenableFuture<ClientHttpResponse> result = execution.executeAsync(request, body);
            result.addCallback(new TraceListenableFutureCallback(span, this.handler));
            ListenableFuture<ClientHttpResponse> listenableFuture = result;
            if (ws != null) {
                ws.close();
            }
            return listenableFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ws != null) {
                    try {
                        ws.close();
                    }
                    catch (Throwable throwable2) {
                    }
                }
                throw throwable;
            }
            catch (IOException | Error | RuntimeException e) {
                this.handler.handleReceive(null, e, span);
                throw e;
            }
        }
    }

    static final class TraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final Span span;
        final HttpClientHandler<HttpRequest, ClientHttpResponse> handler;

        TraceListenableFutureCallback(Span span, HttpClientHandler<HttpRequest, ClientHttpResponse> handler) {
            this.span = span;
            this.handler = handler;
        }

        @Override
        public void onFailure(Throwable ex) {
            this.handler.handleReceive(null, ex, this.span);
        }

        @Override
        public void onSuccess(ClientHttpResponse result) {
            this.handler.handleReceive(result, null, this.span);
        }
    }
}

