/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.ErrorParser;
import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.internal.Nullable;

public class HttpParser {
    static final ErrorParser DEFAULT_ERROR_PARSER = new ErrorParser();

    protected ErrorParser errorParser() {
        return DEFAULT_ERROR_PARSER;
    }

    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer2) {
        String path;
        customizer2.name(this.spanName(adapter, req));
        String method = adapter.method(req);
        if (method != null) {
            customizer2.tag("http.method", method);
        }
        if ((path = adapter.path(req)) != null) {
            customizer2.tag("http.path", path);
        }
    }

    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return adapter.method(req);
    }

    public <Resp> void response(HttpAdapter<?, Resp> adapter, @Nullable Resp res, @Nullable Throwable error, SpanCustomizer customizer2) {
        int statusCode = 0;
        if (res != null) {
            String maybeStatus;
            statusCode = adapter.statusCodeAsInt(res);
            String nameFromRoute = HttpParser.spanNameFromRoute(adapter, res, statusCode);
            if (nameFromRoute != null) {
                customizer2.name(nameFromRoute);
            }
            if ((maybeStatus = this.maybeStatusAsString(statusCode, 299)) != null) {
                customizer2.tag("http.status_code", maybeStatus);
            }
        }
        this.error(statusCode, error, customizer2);
    }

    static <Resp> String spanNameFromRoute(HttpAdapter<?, Resp> adapter, Resp res, int statusCode) {
        String method = adapter.methodFromResponse(res);
        if (method == null) {
            return null;
        }
        String route = adapter.route(res);
        if (route == null) {
            return null;
        }
        if (!"".equals(route)) {
            return method + " " + route;
        }
        if (statusCode / 100 == 3) {
            return method + " redirected";
        }
        if (statusCode == 404) {
            return method + " not_found";
        }
        return null;
    }

    protected void error(@Nullable Integer httpStatus, @Nullable Throwable error, SpanCustomizer customizer2) {
        String maybeErrorStatus;
        if (error != null) {
            this.errorParser().error(error, customizer2);
        } else if (httpStatus != null && (maybeErrorStatus = this.maybeStatusAsString(httpStatus, 399)) != null) {
            customizer2.tag("error", maybeErrorStatus);
        }
    }

    @Nullable
    String maybeStatusAsString(int statusCode, int upperRange) {
        if (statusCode != 0 && (statusCode < 200 || statusCode > upperRange)) {
            return String.valueOf(statusCode);
        }
        return null;
    }
}

