/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.virusscanner.clamav.impl;

import io.mosip.kernel.core.virusscanner.exception.VirusScannerException;
import io.mosip.kernel.core.virusscanner.spi.VirusScanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import xyz.capybara.clamav.ClamavClient;
import xyz.capybara.clamav.commands.scan.result.ScanResult;
import xyz.capybara.clamav.exceptions.ClamavException;

@Component
public class VirusScannerImpl
implements VirusScanner<Boolean, InputStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirusScannerImpl.class);
    @Value(value="${mosip.kernel.virus-scanner.host}")
    private String host;
    @Value(value="${mosip.kernel.virus-scanner.port}")
    private int port;
    protected ClamavClient clamavClient;
    private static final String LOGDISPLAY = "{} - {}";
    private static final String ANTIVIRUS_SERVICE_NOT_ACCESSIBLE = "The anti virus service is not accessible";
    private static final String FILE_NOT_PRESENT = "The file not found for for scanning";

    public void createConnection() {
        if (this.clamavClient == null) {
            this.clamavClient = new ClamavClient(this.host, this.port);
        }
    }

    public Boolean scanFile(String fileName) {
        Boolean result = Boolean.FALSE;
        this.createConnection();
        File file = new File(fileName);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            throw new VirusScannerException("IIS_GEN_FILE_NOT_PRESENT_FOR_SCAN", FILE_NOT_PRESENT, (Throwable)e1);
        }
        try {
            ScanResult scanResult = this.clamavClient.scan((InputStream)is);
            if (scanResult.getStatus() == ScanResult.Status.OK) {
                result = Boolean.TRUE;
            } else {
                Map listOfVirus = scanResult.getFoundViruses();
                LOGGER.warn("Virus Found in file " + fileName + ": ", (Object)listOfVirus);
            }
        }
        catch (ClamavException e) {
            throw new VirusScannerException("IIS_GEN_ANTIVIRUS_SERVICE_NOT_ACCESSIBLE", ANTIVIRUS_SERVICE_NOT_ACCESSIBLE, (Throwable)e);
        }
        return result;
    }

    public Boolean scanFile(InputStream is) {
        Boolean result = Boolean.FALSE;
        this.createConnection();
        try {
            ScanResult scanResult = this.clamavClient.scan(is);
            if (scanResult.getStatus() == ScanResult.Status.OK) {
                result = Boolean.TRUE;
            } else {
                Map listOfVirus = scanResult.getFoundViruses();
                LOGGER.warn("Virus Found in file : " + listOfVirus);
            }
        }
        catch (ClamavException e) {
            throw new VirusScannerException("IIS_GEN_ANTIVIRUS_SERVICE_NOT_ACCESSIBLE", ANTIVIRUS_SERVICE_NOT_ACCESSIBLE, (Throwable)e);
        }
        return result;
    }

    public Boolean scanFolder(String folderPath) {
        File[] files;
        Boolean result = Boolean.TRUE;
        this.createConnection();
        File folder = new File(folderPath);
        for (File file : files = folder.listFiles()) {
            try {
                ScanResult scanResult = this.clamavClient.scan((InputStream)new FileInputStream(file));
                if (scanResult.getStatus() == ScanResult.Status.OK) continue;
                result = Boolean.FALSE;
                break;
            }
            catch (FileNotFoundException e) {
                throw new VirusScannerException("IIS_GEN_FILE_NOT_PRESENT_FOR_SCAN", FILE_NOT_PRESENT, (Throwable)e);
            }
            catch (ClamavException e) {
                throw new VirusScannerException("IIS_GEN_ANTIVIRUS_SERVICE_NOT_ACCESSIBLE", ANTIVIRUS_SERVICE_NOT_ACCESSIBLE, (Throwable)e);
            }
        }
        return result;
    }

    public Boolean scanDocument(byte[] docArray) throws IOException {
        Boolean result = Boolean.FALSE;
        this.createConnection();
        try (ByteArrayInputStream docInputStream = new ByteArrayInputStream(docArray);){
            ScanResult scanResult = this.clamavClient.scan((InputStream)docInputStream);
            if (scanResult.getStatus() == ScanResult.Status.OK) {
                result = Boolean.TRUE;
            } else {
                Map listOfVirus = scanResult.getFoundViruses();
                LOGGER.warn("Virus Found in file " + docInputStream + ": ", (Object)listOfVirus);
            }
        }
        return result;
    }

    public Boolean scanDocument(File doc) throws IOException {
        Boolean result = Boolean.FALSE;
        this.createConnection();
        try (FileInputStream docInputStream = new FileInputStream(doc);){
            ScanResult scanResult = this.clamavClient.scan((InputStream)docInputStream);
            if (scanResult.getStatus() == ScanResult.Status.OK) {
                result = Boolean.TRUE;
            } else {
                Map listOfVirus = scanResult.getFoundViruses();
                LOGGER.warn("Virus Found in file " + doc + ": ", (Object)listOfVirus);
            }
        }
        catch (ClamavException e) {
            LOGGER.error(LOGDISPLAY, (Object)e.getMessage());
            throw new VirusScannerException("IIS_GEN_ANTIVIRUS_SERVICE_NOT_ACCESSIBLE", ANTIVIRUS_SERVICE_NOT_ACCESSIBLE, (Throwable)e);
        }
        return result;
    }
}

