/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.transliteration.icu4j.impl;

import com.ibm.icu.text.Transliterator;
import io.mosip.kernel.core.transliteration.exception.InvalidTransliterationException;
import io.mosip.kernel.core.transliteration.spi.Transliteration;
import io.mosip.kernel.transliteration.icu4j.constant.TransliterationErrorConstant;
import io.mosip.kernel.transliteration.icu4j.constant.TransliterationPropertyConstant;
import org.springframework.stereotype.Component;

@Component
public class TransliterationImpl
implements Transliteration<String> {
    public String transliterate(String fromLanguageCode, String toLanguageCode, String text) {
        Transliterator translitratedLanguage;
        String languageId = fromLanguageCode + TransliterationPropertyConstant.TRANSLITERATION_ID_SEPARATOR.getProperty() + toLanguageCode;
        try {
            translitratedLanguage = Transliterator.getInstance((String)languageId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTransliterationException(TransliterationErrorConstant.TRANSLITERATION_INVALID_ID.getErrorCode(), TransliterationErrorConstant.TRANSLITERATION_INVALID_ID.getErrorMessage(), (Throwable)e);
        }
        return translitratedLanguage.transliterate(text);
    }
}

