/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.transliteration.icu4j.impl;

import com.ibm.icu.text.Transliterator;
import io.mosip.kernel.core.transliteration.exception.InvalidTransliterationException;
import io.mosip.kernel.core.transliteration.spi.Transliteration;
import io.mosip.kernel.transliteration.icu4j.constant.LanguageIdConstant;
import io.mosip.kernel.transliteration.icu4j.constant.TransliterationErrorConstant;
import io.mosip.kernel.transliteration.icu4j.constant.TransliterationPropertyConstant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TransliterationImpl
implements Transliteration<String> {
    @Value(value="${mosip.kernel.transliteration.arabic-language-code}")
    private String arabicLanguageCode;
    @Value(value="${mosip.kernel.transliteration.franch-language-code}")
    private String frenchLanguageCode;
    Map<String, String> languageIdMap;

    @PostConstruct
    private void getLanguageMap() {
        this.languageIdMap = new HashMap<String, String>();
        this.languageIdMap.put(this.arabicLanguageCode, LanguageIdConstant.ARABIC.getLanguage());
        this.languageIdMap.put(this.frenchLanguageCode, LanguageIdConstant.FRENCH.getLanguage());
    }

    public String transliterate(String fromLanguage, String toLanguage, String text) {
        Transliterator translitratedLanguage;
        String fromLanguageCode = this.languageIdMap.get(fromLanguage);
        String toLanguageCode = this.languageIdMap.get(toLanguage);
        if (fromLanguageCode == null || toLanguageCode == null) {
            throw new InvalidTransliterationException(TransliterationErrorConstant.TRANSLITERATION_INVALID_LANGUAGE_CODE.getErrorCode(), TransliterationErrorConstant.TRANSLITERATION_INVALID_LANGUAGE_CODE.getErrorMessage());
        }
        String languageId = fromLanguageCode + TransliterationPropertyConstant.TRANSLITERATION_ID_SEPARATOR.getProperty() + toLanguageCode;
        try {
            translitratedLanguage = Transliterator.getInstance((String)languageId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTransliterationException(TransliterationErrorConstant.TRANSLITERATION_INVALID_ID.getErrorCode(), TransliterationErrorConstant.TRANSLITERATION_INVALID_ID.getErrorMessage(), (Throwable)e);
        }
        return translitratedLanguage.transliterate(text);
    }
}

