/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.idgenerator.exception.TokenIdGeneratorException;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.tokenidgenerator.constant.TokenIDGeneratorErrorCode;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class ApiExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={TokenIdGeneratorException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> emptyLengthException(HttpServletRequest httpServletRequest, TokenIdGeneratorException e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest httpServletRequest, Exception exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(TokenIDGeneratorErrorCode.RUNTIME_EXCEPTION.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

