/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.tokenidgenerator.config.LoggerConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class ResponseBodyAdviceConfig
implements ResponseBodyAdvice<ResponseWrapper<?>> {
    @Autowired
    private ObjectMapper objectMapper;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(ResponseFilter.class);
    }

    public ResponseWrapper<?> beforeBodyWrite(ResponseWrapper<?> body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        RequestWrapper requestWrapper = null;
        String requestBody = null;
        try {
            HttpServletRequest httpServletRequest = ((ServletServerHttpRequest)request).getServletRequest();
            if (httpServletRequest instanceof ContentCachingRequestWrapper) {
                requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
            } else if (httpServletRequest instanceof HttpServletRequestWrapper && ((HttpServletRequestWrapper)httpServletRequest).getRequest() instanceof ContentCachingRequestWrapper) {
                requestBody = new String(((ContentCachingRequestWrapper)((HttpServletRequestWrapper)httpServletRequest).getRequest()).getContentAsByteArray());
            }
            this.objectMapper.registerModule((Module)new JavaTimeModule());
            if (!EmptyCheckUtils.isNullEmpty((String)requestBody)) {
                requestWrapper = (RequestWrapper)this.objectMapper.readValue(requestBody, RequestWrapper.class);
                body.setId(requestWrapper.getId());
                body.setVersion(requestWrapper.getVersion());
            }
            body.setErrors(null);
            return body;
        }
        catch (Exception e) {
            Logger mosipLogger = LoggerConfiguration.logConfig(ResponseBodyAdviceConfig.class);
            mosipLogger.error("", "", "", e.getMessage());
            return body;
        }
    }
}

