/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.templatemanager.velocity.impl;

import io.mosip.kernel.core.templatemanager.exception.TemplateMethodInvocationException;
import io.mosip.kernel.core.templatemanager.exception.TemplateParsingException;
import io.mosip.kernel.core.templatemanager.exception.TemplateResourceNotFoundException;
import io.mosip.kernel.core.templatemanager.spi.TemplateManager;
import io.mosip.kernel.templatemanager.velocity.constant.TemplateManagerConstant;
import io.mosip.kernel.templatemanager.velocity.constant.TemplateManagerExceptionCodeConstant;
import io.mosip.kernel.templatemanager.velocity.util.TemplateManagerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class TemplateManagerImpl
implements TemplateManager {
    private static final String DEFAULT_ENCODING_TYPE = StandardCharsets.UTF_8.name();
    private VelocityEngine velocityEngine;

    public TemplateManagerImpl(VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    public InputStream merge(InputStream is, Map<String, Object> values) throws IOException {
        StringWriter writer = new StringWriter();
        String logTag = "templateManager-mergeTemplate";
        Objects.requireNonNull(is, TemplateManagerConstant.TEMPLATE_INPUT_STREAM_NULL.getMessage());
        Objects.requireNonNull(values, TemplateManagerConstant.TEMPLATE_VALUES_NULL.getMessage());
        VelocityContext context = TemplateManagerUtil.bindInputToContext(values);
        try {
            boolean isMerged = false;
            if (context != null && (isMerged = this.velocityEngine.evaluate((Context)context, (Writer)writer, logTag, (Reader)new InputStreamReader(is)))) {
                return new ByteArrayInputStream(writer.toString().getBytes());
            }
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateResourceNotFoundException(TemplateManagerExceptionCodeConstant.TEMPLATE_NOT_FOUND.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_NOT_FOUND.getErrorMessage(), (Throwable)e);
        }
        catch (ParseErrorException e) {
            throw new TemplateParsingException(TemplateManagerExceptionCodeConstant.TEMPLATE_PARSING.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_PARSING.getErrorMessage(), (Throwable)e);
        }
        catch (MethodInvocationException e) {
            throw new TemplateMethodInvocationException(TemplateManagerExceptionCodeConstant.TEMPLATE_INVALID_REFERENCE.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_INVALID_REFERENCE.getErrorMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean merge(String templateName, Writer writer, Map<String, Object> values) throws IOException {
        return this.merge(templateName, writer, values, DEFAULT_ENCODING_TYPE);
    }

    public boolean merge(String templateName, Writer writer, Map<String, Object> values, String encodingType) throws IOException {
        boolean isMerged = false;
        Template template = null;
        VelocityContext context = null;
        Objects.requireNonNull(templateName, TemplateManagerConstant.TEMPATE_NAME_NULL.getMessage());
        Objects.requireNonNull(writer, TemplateManagerConstant.WRITER_NULL.getMessage());
        Objects.requireNonNull(encodingType, TemplateManagerConstant.ENCODING_TYPE_NULL.getMessage());
        Objects.requireNonNull(values, TemplateManagerConstant.TEMPLATE_VALUES_NULL.getMessage());
        try {
            template = this.velocityEngine.getTemplate(templateName, encodingType);
            context = TemplateManagerUtil.bindInputToContext(values);
            template.merge((Context)context, writer);
            isMerged = true;
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateResourceNotFoundException(TemplateManagerExceptionCodeConstant.TEMPLATE_NOT_FOUND.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_NOT_FOUND.getErrorMessage(), (Throwable)e);
        }
        catch (ParseErrorException e) {
            throw new TemplateParsingException(TemplateManagerExceptionCodeConstant.TEMPLATE_PARSING.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_PARSING.getErrorMessage(), (Throwable)e);
        }
        catch (MethodInvocationException e) {
            throw new TemplateMethodInvocationException(TemplateManagerExceptionCodeConstant.TEMPLATE_INVALID_REFERENCE.getErrorCode(), TemplateManagerExceptionCodeConstant.TEMPLATE_INVALID_REFERENCE.getErrorMessage(), (Throwable)e);
        }
        return isMerged;
    }
}

