/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.templatemanager.velocity.builder;

import io.mosip.kernel.core.templatemanager.spi.TemplateManager;
import io.mosip.kernel.core.templatemanager.spi.TemplateManagerBuilder;
import io.mosip.kernel.templatemanager.velocity.impl.TemplateManagerImpl;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class TemplateManagerBuilderImpl
implements TemplateManagerBuilder {
    private String resourceLoader = "classpath";
    private String templatePath = ".";
    private boolean cache = Boolean.TRUE;
    private String defaultEncoding = StandardCharsets.UTF_8.name();

    public TemplateManagerBuilder resourceLoader(String resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    public TemplateManagerBuilder resourcePath(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public TemplateManagerBuilder enableCache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public TemplateManagerBuilder encodingType(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public TemplateManager build() {
        Properties properties = new Properties();
        properties.put("input.encoding", this.defaultEncoding);
        properties.put("output.encoding", this.defaultEncoding);
        properties.put("ISO-8859-1", this.defaultEncoding);
        properties.put("resource.loader", this.resourceLoader);
        properties.put("file.resource.loader.path", this.templatePath);
        properties.put("file.resource.loader.cache", (Object)this.cache);
        properties.put("runtime.log.logsystem.class", NullLogChute.class.getName());
        properties.put("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.put("file.resource.loader.class", FileResourceLoader.class.getName());
        VelocityEngine engine = new VelocityEngine(properties);
        engine.init();
        return new TemplateManagerImpl(engine);
    }

    @Generated
    public String getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Generated
    public boolean isCache() {
        return this.cache;
    }

    @Generated
    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }
}

