/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.smsserviceprovider.msg91.impl;

import io.mosip.kernel.core.notification.exception.InvalidNumberException;
import io.mosip.kernel.core.notification.model.SMSResponseDto;
import io.mosip.kernel.core.notification.spi.SMSServiceProvider;
import io.mosip.kernel.smsserviceprovider.msg91.constant.SmsExceptionConstant;
import io.mosip.kernel.smsserviceprovider.msg91.constant.SmsPropertyConstant;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class SMSServiceProviderImpl
implements SMSServiceProvider {
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${mosip.kernel.sms.enabled:false}")
    boolean smsEnabled;
    @Value(value="${mosip.kernel.sms.country.code}")
    String countryCode;
    @Value(value="${mosip.kernel.sms.number.min.length}")
    int numberMinLength;
    @Value(value="${mosip.kernel.sms.number.max.length}")
    int numberMaxLength;
    @Value(value="${mosip.kernel.sms.api}")
    String api;
    @Value(value="${mosip.kernel.sms.sender}")
    String sender;
    @Value(value="${mosip.kernel.sms.password:null}")
    private String password;
    @Value(value="${mosip.kernel.sms.route:null}")
    String route;
    @Value(value="${mosip.kernel.sms.authkey:null}")
    String authkey;
    @Value(value="${mosip.kernel.sms.unicode:1}")
    String unicode;
    @Value(value="${mosip.id.validation.identity.phone}")
    private String phoneRegex;

    public SMSResponseDto sendSms(String contactNumber, String message) {
        SMSResponseDto smsResponseDTO = new SMSResponseDto();
        this.validateInput(contactNumber);
        UriComponentsBuilder sms = UriComponentsBuilder.fromHttpUrl((String)this.api).queryParam(SmsPropertyConstant.AUTH_KEY.getProperty(), new Object[]{this.authkey}).queryParam(SmsPropertyConstant.SMS_MESSAGE.getProperty(), new Object[]{message.replaceAll("\\#", "%23")}).queryParam(SmsPropertyConstant.ROUTE.getProperty(), new Object[]{this.route}).queryParam(SmsPropertyConstant.SENDER_ID.getProperty(), new Object[]{this.sender}).queryParam(SmsPropertyConstant.RECIPIENT_NUMBER.getProperty(), new Object[]{contactNumber}).queryParam(SmsPropertyConstant.UNICODE.getProperty(), new Object[]{this.unicode}).queryParam(SmsPropertyConstant.COUNTRY_CODE.getProperty(), new Object[]{this.countryCode});
        try {
            this.restTemplate.getForEntity(URLDecoder.decode(sms.toUriString(), StandardCharsets.UTF_8), String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            throw new RuntimeException(e.getResponseBodyAsString());
        }
        smsResponseDTO.setMessage(SmsPropertyConstant.SUCCESS_RESPONSE.getProperty());
        smsResponseDTO.setStatus("success");
        return smsResponseDTO;
    }

    private void validateInput(String contactNumber) {
        if (!this.phoneValidator(contactNumber)) {
            throw new InvalidNumberException(SmsExceptionConstant.SMS_INVALID_CONTACT_NUMBER.getErrorCode(), SmsExceptionConstant.SMS_INVALID_CONTACT_NUMBER.getErrorMessage());
        }
    }

    public boolean phoneValidator(String phone) {
        return phone.matches(this.phoneRegex);
    }
}

