/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.smsserviceprovider.msg91.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.notification.exception.InvalidNumberException;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.smsserviceprovider.msg91.constant.SmsExceptionConstant;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.util.ContentCachingRequestWrapper;

@Order(value=0x7FFFFFFF)
@RestControllerAdvice
public class ApiExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;
    private static final String WHITESPACE = " ";

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> smsInvalidInputsFound(HttpServletRequest httpServletRequest, MethodArgumentNotValidException exception) throws IOException {
        ResponseWrapper<ServiceError> responseWrapper = this.setErrors(httpServletRequest);
        BindingResult bindingResult = exception.getBindingResult();
        List fieldErrors = bindingResult.getFieldErrors();
        fieldErrors.forEach(x -> {
            ServiceError error = new ServiceError(SmsExceptionConstant.SMS_ILLEGAL_INPUT.getErrorCode(), x.getField() + WHITESPACE + x.getDefaultMessage());
            responseWrapper.getErrors().add(error);
        });
        return new ResponseEntity(responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidNumberException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> smsNotificationInvalidNumber(HttpServletRequest httpServletRequest, InvalidNumberException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(SmsExceptionConstant.SMS_ILLEGAL_INPUT.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpClientErrorException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> smsVendorServiceException(HttpServletRequest httpServletRequest, HttpClientErrorException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        JsonNode responseTree = this.objectMapper.readTree(e.getResponseBodyAsString());
        String errorMessage = null;
        if (responseTree != null) {
            responseTree = responseTree.get("requestError").get("serviceException");
            errorMessage = responseTree.get("text").asText();
        } else {
            errorMessage = e.getMessage();
        }
        ServiceError error = new ServiceError(SmsExceptionConstant.SMS_INVALID_CREDENTIAL.getErrorCode(), errorMessage);
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpServerErrorException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> httpServerErrorException(HttpServletRequest httpServletRequest, HttpServerErrorException exception) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        JsonNode responseTree = this.objectMapper.readTree(exception.getResponseBodyAsString());
        String errorMessage = null;
        if (responseTree != null) {
            responseTree = responseTree.get("requestError").get("serviceException");
            errorMessage = responseTree.get("text").asText();
        } else {
            errorMessage = exception.getMessage();
        }
        ServiceError error = new ServiceError("KER-NOS-004", errorMessage);
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest httpServletRequest, Exception e) throws IOException {
        ResponseWrapper<ServiceError> responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(SmsExceptionConstant.INTERNAL_SERVER_ERROR.getErrorCode(), e.getMessage());
        responseWrapper.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(responseWrapper, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

