/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.signatureutil.spi.SignatureUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.dto.PublicKeyRequestDto;
import io.mosip.kernel.signature.dto.SignRequestDto;
import io.mosip.kernel.signature.dto.TimestampRequestDto;
import io.mosip.kernel.signature.dto.ValidatorResponseDto;
import io.mosip.kernel.signature.exception.PublicKeyParseException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureService;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignatureServiceImpl
implements SignatureService {
    @Autowired
    private SignatureUtil signatureUtil;

    public SignatureResponse sign(SignRequestDto signRequestDto) {
        return this.signatureUtil.sign(signRequestDto.getData(), DateUtils.getUTCCurrentDateTimeString());
    }

    public ValidatorResponseDto validateWithPublicKey(PublicKeyRequestDto validateWithPublicKeyRequestDto) throws InvalidKeySpecException, NoSuchAlgorithmException {
        boolean status = this.signatureUtil.validateWithPublicKey(validateWithPublicKeyRequestDto.getSignature(), validateWithPublicKeyRequestDto.getData(), validateWithPublicKeyRequestDto.getPublickey());
        if (status) {
            ValidatorResponseDto response = new ValidatorResponseDto();
            response.setMessage("Validation Successful");
            response.setStatus("success");
            return response;
        }
        throw new SignatureFailureException(SignatureErrorCode.NOT_VALID.getErrorCode(), SignatureErrorCode.NOT_VALID.getErrorMessage(), null);
    }

    public ValidatorResponseDto validate(TimestampRequestDto timestampRequestDto) {
        boolean status;
        try {
            status = this.signatureUtil.validate(timestampRequestDto.getSignature(), timestampRequestDto.getData(), DateUtils.formatToISOString((LocalDateTime)timestampRequestDto.getTimestamp()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new PublicKeyParseException(SignatureErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), (Throwable)exception);
        }
        if (status) {
            ValidatorResponseDto response = new ValidatorResponseDto();
            response.setMessage("Validation Successful");
            response.setStatus("success");
            return response;
        }
        throw new SignatureFailureException(SignatureErrorCode.NOT_VALID.getErrorCode(), SignatureErrorCode.NOT_VALID.getErrorMessage(), null);
    }
}

