/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.BaseUncheckedException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.signatureutil.exception.ParseResponseException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilClientException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilException;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.exception.RequestException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class ApiExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={RequestException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> controlRequestException(HttpServletRequest httpServletRequest, RequestException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={SignatureFailureException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureFailureException(HttpServletRequest httpServletRequest, SignatureFailureException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={SignatureUtilClientException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureUtilClientException(HttpServletRequest httpServletRequest, SignatureUtilClientException e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        responseWrapper.getErrors().addAll(e.getList());
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity((Object)responseWrapper, HttpStatus.OK);
    }

    @ExceptionHandler(value={SignatureUtilException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureUtilException(HttpServletRequest httpServletRequest, SignatureUtilException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={ParseResponseException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> parseResponseException(HttpServletRequest httpServletRequest, ParseResponseException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> methodArgumentNotValidException(HttpServletRequest httpServletRequest, MethodArgumentNotValidException e) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        List fieldErrors = e.getBindingResult().getFieldErrors();
        fieldErrors.forEach(x -> {
            ServiceError error = new ServiceError(SignatureErrorCode.REQUEST_DATA_NOT_VALID.getErrorCode(), x.getField() + ": " + x.getDefaultMessage());
            errorResponse.getErrors().add(error);
        });
        return new ResponseEntity((Object)errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException e) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(SignatureErrorCode.REQUEST_DATA_NOT_VALID.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity((Object)errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultServiceErrorHandler(HttpServletRequest request, Exception e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(request);
        ServiceError error = new ServiceError(SignatureErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), e.getMessage());
        responseWrapper.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity((Object)responseWrapper, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseEntity<ResponseWrapper<ServiceError>> getErrorResponseEntity(BaseUncheckedException e, HttpStatus httpStatus, HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, httpStatus);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponsetime(LocalDateTime.now(ZoneId.of("UTC")));
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

