/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    @Value(value="${application.env.local:false}")
    private Boolean localEnv;
    @Value(value="${swagger.base-url:#{null}}")
    private String swaggerBaseUrl;
    @Value(value="${server.port:8080}")
    private int serverPort;
    String proto = "http";
    String host = "localhost";
    int port = -1;
    String hostWithPort = "localhost:8080";

    @Bean
    public Docket api() {
        boolean swaggerBaseUrlSet = false;
        if (!this.localEnv.booleanValue() && this.swaggerBaseUrl != null && !this.swaggerBaseUrl.isEmpty()) {
            try {
                this.proto = new URL(this.swaggerBaseUrl).getProtocol();
                this.host = new URL(this.swaggerBaseUrl).getHost();
                this.port = new URL(this.swaggerBaseUrl).getPort();
                this.hostWithPort = this.port == -1 ? this.host : this.host + ":" + this.port;
                swaggerBaseUrlSet = true;
            }
            catch (MalformedURLException e) {
                System.err.println("SwaggerUrlException: " + e);
            }
        }
        Docket docket = new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"(?!/(error).*).*")).build();
        if (swaggerBaseUrlSet) {
            docket.protocols(this.protocols()).host(this.hostWithPort);
            System.out.println("\nSwagger Base URL: " + this.proto + "://" + this.hostWithPort + "\n");
        }
        return docket;
    }

    private Set<String> protocols() {
        HashSet<String> protocols = new HashSet<String>();
        protocols.add(this.proto);
        return protocols;
    }
}

