/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.ridgenerator.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.ridgenerator.constant.RidGeneratorExceptionConstant;
import io.mosip.kernel.ridgenerator.exception.EmptyInputException;
import io.mosip.kernel.ridgenerator.exception.InputLengthException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class ApiExceptionalHandler {
    @Autowired
    private ObjectMapper objectMapper;
    public static final String WHITESPACE = " ";

    @ExceptionHandler(value={InputLengthException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> inputLengthException(HttpServletRequest httpServletRequest, InputLengthException e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={EmptyInputException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> emptyLengthException(HttpServletRequest httpServletRequest, EmptyInputException e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(RidGeneratorExceptionConstant.HTTP_MESSAGE_NOT_READABLE.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest httpServletRequest, Exception exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(RidGeneratorExceptionConstant.RUNTIME_EXCEPTION.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

