/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.ridgenerator.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.ridgenerator.dto.RidGeneratorResponseDto;
import io.mosip.kernel.ridgenerator.service.RidGeneratorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="ridgenerator", description="Operation related to RID generation")
public class RidGeneratorController {
    @Autowired
    private RidGeneratorService<RidGeneratorResponseDto> ridGeneratorService;

    @ResponseFilter
    @Operation(summary="This endpoint handles the RID generation", description="This endpoint handles the RID generation", tags={"ridgenerator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@authorizedRoles.getGetgenerateridcenteridmachineid())")
    @GetMapping(value={"/generate/rid/{centerid}/{machineid}"})
    public ResponseWrapper<RidGeneratorResponseDto> generateRid(@PathVariable(value="centerid") String centerId, @PathVariable(value="machineid") String machineId) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)((RidGeneratorResponseDto)this.ridGeneratorService.generateRid(centerId.trim(), machineId.trim())));
        return responseWrapper;
    }
}

